import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.TModelKey;
import java.security.Security;
import java.util.Vector;

public class UDDISaveBinding1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		TModelList tl = proxy.find_tModel("servicesweb-compagnie-com:inquiry", null, null, null, 0 );

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		System.out.println(tis.size()+" tmodel(s) found\n");
		TModelInfo ti = null;
		Vector tiv = tis.getTModelInfoVector();
		for (int i = 0; i < tiv.size(); i++) {
			ti = (TModelInfo)tiv.elementAt(i);
			System.out.println(ti.getNameString());
			System.out.println(ti.getTModelKey());
			System.out.println("\n");
		}

		Vector names = new Vector();
		names.add(new Name("Services Web & compagnie"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, null, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		AuthToken at = proxy.get_authToken("user", "password");

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");

			names = new Vector();
			names.add(new Name("Mon API de recherche UDDI"));
			ServiceList sl = proxy.find_service(bi.getBusinessKey(), names, null, null, null, 0);

			ServiceInfos sis = sl.getServiceInfos();
			if (sis.size() == 0) {
				System.out.println("no service(s) found");
			}
			else {
				System.out.println(sis.size()+" service(s) found\n");
				Vector siv = sis.getServiceInfoVector();
				for (int j = 0; j < siv.size(); j++) {
					ServiceInfo si = (ServiceInfo)siv.elementAt(j);
					System.out.println(si.getNameString());
					System.out.println(si.getServiceKey());
					System.out.println("\n");

					BindingTemplate bt = new BindingTemplate();
					bt.setBindingKey("");
					bt.setServiceKey(si.getServiceKey());

					TModelInstanceInfo tmii = new TModelInstanceInfo();
					tmii.setTModelKey(ti.getTModelKey());

					TModelInstanceDetails tmid = new TModelInstanceDetails();
					Vector bttiiv = new Vector();
					bttiiv.addElement(tmii);
					tmid.setTModelInstanceInfoVector(bttiiv);

					bt.setTModelInstanceDetails(tmid);

					Vector btdsv = new Vector();
					Description btd = new Description("URL de mon instance d'API de recherche UDDI.");
					btdsv.addElement(btd);
					bt.setDescriptionVector(btdsv);

					AccessPoint accessPoint = new AccessPoint("http://monserveur:80/mawebapplication/servlet/rpcrouter", "http");
					bt.setAccessPoint(accessPoint);

					Vector bindings = new Vector();
					bindings.add(bt);
					BindingDetail bd = proxy.save_binding(at.getAuthInfoString(), bindings);
					System.out.println( "new binding template saved\n" );

					TModelBag tb = new TModelBag();
					tb.add(new TModelKey(ti.getTModelKey()));
					bd = proxy.find_binding(null, si.getServiceKey(), tb, 0);

					Vector bdv = bd.getBindingTemplateVector();
					if (bdv.size() == 0) {
						System.out.println("no binding(s) found");
					}
					else {
						System.out.println(bdv.size()+" binding(s) found\n");
						for (int k = 0; k < bdv.size(); k++) {
							bt = (BindingTemplate)bdv.elementAt(k);
							System.out.println(bt.getDefaultDescriptionString());
							System.out.println(bt.getBindingKey());
							System.out.println("\n");
						}
					}
				}
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
    }
}